<?php
require_once '../../config/config.php';
require_once '../../config/auth.php';
require_once '../../config/database.php';
require_once '../../helpers/format_uang.php';
require_once '../../helpers/tanggal.php';

require_once '../../templates/header.php';
require_once '../../templates/sidebar.php';

// Ambil transaksi kasir
$transaksi = $db->query("
    SELECT k.*, i.nama_barang 
    FROM kasir_transaksi k
    JOIN inventory_stok i ON k.barang_id = i.id
    ORDER BY k.tanggal DESC
");
?>

<h2>Transaksi Kasir</h2>

<table class="table">
    <thead>
        <tr>
            <th>No</th>
            <th>Tanggal</th>
            <th>Barang</th>
            <th>Jumlah</th>
            <th>Total</th>
        </tr>
    </thead>
    <tbody>
        <?php $no=1; while($t = $transaksi->fetch_assoc()): ?>
        <tr>
            <td><?= $no++; ?></td>
            <td><?= tanggal($t['tanggal']); ?></td>
            <td><?= $t['nama_barang']; ?></td>
            <td><?= $t['jumlah']; ?></td>
            <td><?= format_uang($t['total']); ?></td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<?php require_once '../../templates/footer.php'; ?>
